
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_BloodProductModifications : BaseTest 
	{
		
		private DataTable _dtProductModifications;

		[SetUp]
		protected void SetUp() 
		{			
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtProductModifications = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM ProductModificationParameter WHERE DivisionCode = '" + this.TestDivisionCode + "'",  true);
				
				this.RefreshData = false;
			}

		}


		[Test]
		public void GetExistingProductModifications_Pass()
		{
			DataTable dtTest = DAL.BloodProductModifications.GetExistingProductModifications(this.TestDivisionCode);
			
			Assert.AreEqual(this._dtProductModifications.Rows.Count, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(4, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductModificationParameter.ProductModificationCode), TABLES.ProductModificationParameter.ProductModificationCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductModificationParameter.ProductModificationCost), TABLES.ProductModificationParameter.ProductModificationCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductModificationParameter.RecordStatusCode), TABLES.ProductModificationParameter.ProductModificationCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductModificationParameter.RowVersion), TABLES.ProductModificationParameter.ProductModificationCode);
		}

		[Test]
		public void GetExistingProductModifications_Fail()
		{
			DataTable dtTest = DAL.BloodProductModifications.GetExistingProductModifications(string.Empty);			

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}
	}
}

#endif




